/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.ud;

import edu.stanford.nlp.international.Language;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.objectbank.DelimitRegExIterator;
import edu.stanford.nlp.objectbank.IteratorFromReaderFactory;
import edu.stanford.nlp.objectbank.ObjectBank;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.trees.TypedDependency;
import edu.stanford.nlp.trees.ud.CoNLLUUtils;
import edu.stanford.nlp.util.IntPair;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.function.Function;

public class CoNLLUDocumentReader
implements IteratorFromReaderFactory<SemanticGraph> {
    private static final String COMMENT_POS = "<COMMENT>";
    private IteratorFromReaderFactory<SemanticGraph> ifrf = DelimitRegExIterator.getFactory("\n(\\s*\n)+", new SentenceProcessor());
    private static final Comparator<IndexedWord> byIndex = (i1, i2) -> i1.compareTo((IndexedWord)i2);
    private static final Comparator<IndexedWord> byType = (i1, i2) -> i1.containsKey(CoreAnnotations.CoNLLUTokenSpanAnnotation.class) ? -1 : (i2.containsKey(CoreAnnotations.CoNLLUTokenSpanAnnotation.class) ? 1 : 0);

    @Override
    public Iterator<SemanticGraph> getIterator(Reader r) {
        return this.ifrf.getIterator(r);
    }

    private static class WordProcessor
    implements Function<String, IndexedWord> {
        private WordProcessor() {
        }

        @Override
        public IndexedWord apply(String line) {
            IndexedWord word = new IndexedWord();
            if (line.startsWith("#")) {
                word.setWord(line);
                word.setTag(CoNLLUDocumentReader.COMMENT_POS);
                return word;
            }
            String[] bits = line.split("\\s+");
            word.set(CoreAnnotations.TextAnnotation.class, bits[1]);
            if (bits[0].contains("-")) {
                String[] span = bits[0].split("-");
                Integer start = Integer.parseInt(span[0]);
                Integer end = Integer.parseInt(span[1]);
                word.set(CoreAnnotations.CoNLLUTokenSpanAnnotation.class, new IntPair(start, end));
                word.set(CoreAnnotations.IndexAnnotation.class, start);
            } else {
                word.set(CoreAnnotations.IndexAnnotation.class, Integer.parseInt(bits[0]));
                word.set(CoreAnnotations.LemmaAnnotation.class, bits[2]);
                word.set(CoreAnnotations.CoarseTagAnnotation.class, bits[3]);
                word.set(CoreAnnotations.PartOfSpeechAnnotation.class, bits[4]);
                word.set(CoreAnnotations.CoNLLDepParentIndexAnnotation.class, Integer.parseInt(bits[6]));
                word.set(CoreAnnotations.CoNLLDepTypeAnnotation.class, bits[7]);
                word.set(CoreAnnotations.CoNLLUMisc.class, bits[9]);
                word.setIndex(Integer.parseInt(bits[0]));
                word.setValue(bits[1]);
                HashMap<String, String> features = CoNLLUUtils.parseFeatures(bits[5]);
                word.set(CoreAnnotations.CoNLLUFeats.class, features);
                HashMap<Integer, String> extraDeps = CoNLLUUtils.parseExtraDeps(bits[8]);
                word.set(CoreAnnotations.CoNLLUSecondaryDepsAnnotation.class, extraDeps);
            }
            return word;
        }
    }

    private static class SentenceProcessor
    implements Function<String, SemanticGraph> {
        private int lineNumberCounter = 0;

        private SentenceProcessor() {
        }

        @Override
        public SemanticGraph apply(String line) {
            if (line == null) {
                return null;
            }
            WordProcessor func = new WordProcessor();
            ObjectBank<IndexedWord> words = ObjectBank.getLineIterator(new StringReader(line), func);
            ArrayList<IndexedWord> wordList = new ArrayList<IndexedWord>(words);
            ArrayList sorted = new ArrayList(wordList.size());
            LinkedList comments = new LinkedList();
            wordList.stream().filter(w -> w.tag() != null && w.tag().equals(CoNLLUDocumentReader.COMMENT_POS)).forEach(w -> {
                ++this.lineNumberCounter;
                comments.add(w.word());
            });
            wordList.stream().filter(w -> w.tag() == null || !w.tag().equals(CoNLLUDocumentReader.COMMENT_POS)).sorted(byIndex.thenComparing(byType)).forEach(w -> sorted.add(w));
            ArrayList sortedTokens = new ArrayList(wordList.size());
            sorted.stream().filter(w -> !w.containsKey(CoreAnnotations.CoNLLUTokenSpanAnnotation.class)).forEach(w -> sortedTokens.add(w));
            ArrayList<TypedDependency> deps = new ArrayList<TypedDependency>(sorted.size());
            IntPair tokenSpan = null;
            String originalToken = null;
            for (IndexedWord word : sorted) {
                IndexedWord gov;
                ++this.lineNumberCounter;
                if (word.containsKey(CoreAnnotations.CoNLLUTokenSpanAnnotation.class)) {
                    tokenSpan = (IntPair)word.get(CoreAnnotations.CoNLLUTokenSpanAnnotation.class);
                    originalToken = word.word();
                    continue;
                }
                if (tokenSpan != null && tokenSpan.getTarget() >= word.index()) {
                    word.setOriginalText(originalToken);
                    word.set(CoreAnnotations.CoNLLUTokenSpanAnnotation.class, tokenSpan);
                } else {
                    tokenSpan = null;
                    originalToken = null;
                }
                GrammaticalRelation reln = GrammaticalRelation.valueOf(Language.UniversalEnglish, (String)word.get(CoreAnnotations.CoNLLDepTypeAnnotation.class));
                int govIdx = (Integer)word.get(CoreAnnotations.CoNLLDepParentIndexAnnotation.class);
                if (govIdx == 0) {
                    gov = new IndexedWord(word.docID(), word.sentIndex(), 0);
                    gov.setValue("ROOT");
                    if (((String)word.get(CoreAnnotations.CoNLLDepTypeAnnotation.class)).equals("root")) {
                        reln = GrammaticalRelation.ROOT;
                    }
                } else {
                    gov = (IndexedWord)sortedTokens.get(govIdx - 1);
                }
                TypedDependency dep = new TypedDependency(reln, gov, word);
                word.set(CoreAnnotations.LineNumberAnnotation.class, this.lineNumberCounter);
                deps.add(dep);
                HashMap extraDeps = (HashMap)word.get(CoreAnnotations.CoNLLUSecondaryDepsAnnotation.class);
                for (Integer extraGovIdx : extraDeps.keySet()) {
                    GrammaticalRelation extraReln = GrammaticalRelation.valueOf(Language.UniversalEnglish, (String)extraDeps.get(extraGovIdx));
                    IndexedWord extraGov = (IndexedWord)sortedTokens.get(extraGovIdx - 1);
                    TypedDependency extraDep = new TypedDependency(extraReln, extraGov, word);
                    extraDep.setExtra();
                    deps.add(extraDep);
                }
            }
            ++this.lineNumberCounter;
            SemanticGraph sg = new SemanticGraph(deps);
            comments.forEach(c -> sg.addComment((String)c));
            return sg;
        }
    }
}

