/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.scoref;

import edu.stanford.nlp.hcoref.CorefCoreAnnotations;
import edu.stanford.nlp.hcoref.CorefDocMaker;
import edu.stanford.nlp.hcoref.CorefPrinter;
import edu.stanford.nlp.hcoref.CorefProperties;
import edu.stanford.nlp.hcoref.CorefSystem;
import edu.stanford.nlp.hcoref.Scorer;
import edu.stanford.nlp.hcoref.data.CorefChain;
import edu.stanford.nlp.hcoref.data.CorefCluster;
import edu.stanford.nlp.hcoref.data.Dictionaries;
import edu.stanford.nlp.hcoref.data.Document;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.scoref.BestFirstCorefSystem;
import edu.stanford.nlp.scoref.ClusteringCorefSystem;
import edu.stanford.nlp.scoref.DocumentProcessor;
import edu.stanford.nlp.scoref.StatisticalCorefProperties;
import edu.stanford.nlp.scoref.StatisticalCorefUtils;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.RuntimeInterruptedException;
import edu.stanford.nlp.util.StringUtils;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

public abstract class StatisticalCorefSystem {
    public final Dictionaries dictionaries;
    private final Properties props;
    private final CorefDocMaker docMaker;

    public StatisticalCorefSystem(Properties props) {
        this.props = StatisticalCorefProperties.addHcorefProps(props);
        try {
            this.dictionaries = new Dictionaries(this.props);
            this.docMaker = new CorefDocMaker(this.props, this.dictionaries);
        }
        catch (Exception e) {
            throw new RuntimeException("Error initializing coref system", e);
        }
    }

    public static StatisticalCorefSystem fromProps(Properties props) {
        try {
            if (StatisticalCorefProperties.cluster(props)) {
                return new ClusteringCorefSystem(props, StatisticalCorefProperties.clusteringModelPath(props), StatisticalCorefProperties.classificationModelPath(props), StatisticalCorefProperties.rankingModelPath(props), StatisticalCorefProperties.anaphoricityModelPath(props), StatisticalCorefProperties.wordCountsPath(props));
            }
            return new BestFirstCorefSystem(props, StatisticalCorefProperties.wordCountsPath(props), StatisticalCorefProperties.rankingModelPath(props), StatisticalCorefProperties.maxMentionDistance(props), StatisticalCorefProperties.maxMentionDistanceWithStringMatch(props), StatisticalCorefProperties.pairwiseScoreThresholds(props));
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating coreference system", e);
        }
    }

    public void annotate(Annotation ann) {
        this.annotate(ann, true);
    }

    public void annotate(Annotation ann, boolean removeSingletonClusters) {
        try {
            Document document = this.docMaker.makeDocument(ann);
            if (Thread.interrupted()) {
                throw new RuntimeInterruptedException();
            }
            this.runCoref(document);
            if (removeSingletonClusters) {
                StatisticalCorefUtils.removeSingletonClusters(document);
            }
            if (Thread.interrupted()) {
                throw new RuntimeInterruptedException();
            }
            Map<Integer, CorefChain> result = Generics.newHashMap();
            for (CorefCluster c : document.corefClusters.values()) {
                result.put(c.clusterID, new CorefChain(c, document.positions));
            }
            ann.set(CorefCoreAnnotations.CorefChainAnnotation.class, result);
        }
        catch (Exception e) {
            throw new RuntimeException("Error annotating document with coref", e);
        }
    }

    public void runOnConll() throws Exception {
        String baseName = StatisticalCorefProperties.conllOutputPath(this.props) + Calendar.getInstance().getTime().toString().replaceAll("\\s", "-").replaceAll(":", "-");
        String goldOutput = baseName + ".gold.txt";
        String beforeCorefOutput = baseName + ".predicted.txt";
        String afterCorefOutput = baseName + ".coref.predicted.txt";
        final PrintWriter writerGold = new PrintWriter(new FileOutputStream(goldOutput));
        final PrintWriter writerBeforeCoref = new PrintWriter(new FileOutputStream(beforeCorefOutput));
        final PrintWriter writerAfterCoref = new PrintWriter(new FileOutputStream(afterCorefOutput));
        new DocumentProcessor(){

            @Override
            public void process(int id, Document document) {
                writerGold.print(CorefPrinter.printConllOutput(document, true));
                writerBeforeCoref.print(CorefPrinter.printConllOutput(document, false));
                StatisticalCorefSystem.this.runCoref(document);
                StatisticalCorefUtils.removeSingletonClusters(document);
                writerAfterCoref.print(CorefPrinter.printConllOutput(document, false, true));
            }

            @Override
            public void finish() throws Exception {
            }

            @Override
            public String getName() {
                return StatisticalCorefSystem.this.getClass().getSimpleName();
            }
        }.run(this.docMaker);
        Logger logger = Logger.getLogger(CorefSystem.class.getName());
        String summary = Scorer.getEvalSummary(CorefProperties.getPathScorer(this.props), goldOutput, beforeCorefOutput);
        CorefPrinter.printScoreSummary(summary, logger, false);
        summary = Scorer.getEvalSummary(CorefProperties.getPathScorer(this.props), goldOutput, afterCorefOutput);
        CorefPrinter.printScoreSummary(summary, logger, true);
        CorefPrinter.printFinalConllScore(summary);
        writerGold.close();
        writerBeforeCoref.close();
        writerAfterCoref.close();
    }

    public abstract void runCoref(Document var1);

    public static void main(String[] args) throws Exception {
        Properties props = StringUtils.argsToProperties("-props", args[0]);
        StatisticalCorefSystem coref = StatisticalCorefSystem.fromProps(props);
        coref.runOnConll();
    }
}

