/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.pipeline.AnnotatorImplementations;
import edu.stanford.nlp.util.Factory;
import java.util.Properties;

public abstract class AnnotatorFactory
implements Factory<Annotator> {
    private static final long serialVersionUID = -1554647325549869340L;
    protected final Properties properties = new Properties();
    private final AnnotatorImplementations implementations;

    protected AnnotatorFactory(Properties properties, AnnotatorImplementations implementations) {
        for (String key : properties.stringPropertyNames()) {
            this.properties.setProperty(key, properties.getProperty(key));
        }
        this.implementations = implementations;
    }

    @Override
    public abstract Annotator create();

    public String signature() {
        return this.implementations.getClass().getName() + ":" + this.additionalSignature();
    }

    protected abstract String additionalSignature();

    static String baseSignature(Properties props, String name) {
        String prefix = name + ".";
        StringBuilder signature = new StringBuilder();
        for (String key : props.stringPropertyNames()) {
            if (!key.startsWith(prefix)) continue;
            signature.append(key).append("=").append(props.getProperty(key)).append("\n");
        }
        return signature.toString();
    }
}

