/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.ling.CategoryWordTag;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.Sentence;
import edu.stanford.nlp.parser.lexparser.AbstractTreebankParserParams;
import edu.stanford.nlp.parser.lexparser.BaseLexicon;
import edu.stanford.nlp.parser.lexparser.Lexicon;
import edu.stanford.nlp.parser.lexparser.NegraPennCollinizer;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.trees.DiskTreebank;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.MemoryTreebank;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeReaderFactory;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.trees.international.negra.NegraHeadFinder;
import edu.stanford.nlp.trees.international.negra.NegraLabel;
import edu.stanford.nlp.trees.international.negra.NegraPennLanguagePack;
import edu.stanford.nlp.trees.international.negra.NegraPennTreeReaderFactory;
import edu.stanford.nlp.util.Index;
import java.util.ArrayList;
import java.util.List;

public class NegraPennTreebankParserParams
extends AbstractTreebankParserParams {
    private static final long serialVersionUID = 757812264219400466L;
    private static final boolean DEBUG = false;
    private boolean markRC = false;
    private boolean markZuVP = false;
    private boolean markLP = false;
    private boolean markColon = false;
    private boolean markKonjParent = false;
    private boolean markHDParent = false;
    private boolean markContainsV = false;
    private static final boolean defaultLeaveGF = false;
    private static final char defaultGFCharacter = '-';
    private int nodeCleanup = 2;
    private HeadFinder headFinder = new NegraHeadFinder();
    private boolean treeNormalizerInsertNPinPP = false;
    private boolean treeNormalizerLeaveGF = false;
    private NegraPennTreeReaderFactory treeReaderFactory;

    public NegraPennTreebankParserParams() {
        super(new NegraPennLanguagePack(false, '-'));
        this.setOutputEncoding("UTF-8");
    }

    @Override
    public HeadFinder headFinder() {
        return this.headFinder;
    }

    @Override
    public HeadFinder typedDependencyHeadFinder() {
        return this.headFinder();
    }

    @Override
    public Lexicon lex(Options op, Index<String> wordIndex, Index<String> tagIndex) {
        if (op.lexOptions.uwModelTrainer == null) {
            op.lexOptions.uwModelTrainer = "edu.stanford.nlp.parser.lexparser.GermanUnknownWordModelTrainer";
        }
        return new BaseLexicon(op, wordIndex, tagIndex);
    }

    @Override
    public TreeReaderFactory treeReaderFactory() {
        if (this.treeReaderFactory == null) {
            this.treeReaderFactory = new NegraPennTreeReaderFactory(this.nodeCleanup, this.treeNormalizerInsertNPinPP, this.treeNormalizerLeaveGF, this.treebankLanguagePack());
        }
        return this.treeReaderFactory;
    }

    @Override
    public MemoryTreebank memoryTreebank() {
        return new MemoryTreebank(this.treeReaderFactory(), this.inputEncoding);
    }

    @Override
    public DiskTreebank diskTreebank() {
        return new DiskTreebank(this.treeReaderFactory(), this.inputEncoding);
    }

    @Override
    public TreeTransformer collinizer() {
        return new NegraPennCollinizer(this);
    }

    @Override
    public TreeTransformer collinizerEvalb() {
        return new NegraPennCollinizer(this, false);
    }

    @Override
    public String[] sisterSplitters() {
        return new String[0];
    }

    @Override
    public int setOptionFlag(String[] args, int i) {
        if (args[i].equalsIgnoreCase("-nodeCleanup")) {
            this.nodeCleanup = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-leaveGF")) {
            ((NegraPennLanguagePack)this.treebankLanguagePack()).setLeaveGF(true);
            this.treeNormalizerLeaveGF = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-gfCharacter")) {
            String gfChar = args[i + 1];
            if (gfChar.length() > 1) {
                System.out.println("Warning! gfCharacter argument ignored; must specify a character, not a String");
            }
            this.treebankLanguagePack().setGfCharacter(gfChar.charAt(0));
            i += 2;
        } else if (args[i].equalsIgnoreCase("-markZuVP")) {
            this.markZuVP = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-markRC")) {
            this.markRC = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-insertNPinPP")) {
            this.treeNormalizerInsertNPinPP = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-markLP")) {
            this.markLP = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-markColon")) {
            this.markColon = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-markKonjParent")) {
            this.markKonjParent = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-markHDParent")) {
            this.markHDParent = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-markContainsV")) {
            this.markContainsV = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-evalGF")) {
            this.setEvalGF(Boolean.parseBoolean(args[i + 1]));
            i += 2;
        } else if (args[i].equalsIgnoreCase("-headFinder") && i + 1 < args.length) {
            try {
                this.headFinder = (HeadFinder)Class.forName(args[i + 1]).newInstance();
            }
            catch (Exception e) {
                System.err.println(e);
                System.err.println(this.getClass().getName() + ": Could not load head finder " + args[i + 1]);
            }
            i += 2;
        }
        return i;
    }

    @Override
    public void display() {
        System.err.println("NegraPennTreebankParserParams");
        System.err.println("  markZuVP=" + this.markZuVP);
        System.err.println("  insertNPinPP=" + this.treeNormalizerInsertNPinPP);
        System.err.println("  leaveGF=" + this.treeNormalizerLeaveGF);
        System.out.println("markLP=" + this.markLP);
        System.out.println("markColon=" + this.markColon);
    }

    private String basicCat(String str) {
        return this.treebankLanguagePack().basicCategory(str);
    }

    @Override
    public Tree transformTree(Tree t, Tree root) {
        if (t == null || t.isLeaf()) {
            return t;
        }
        ArrayList<String> annotations = new ArrayList<String>();
        CoreLabel lab = (CoreLabel)t.label();
        String word = lab.word();
        String tag = lab.tag();
        String cat = lab.value();
        String baseCat = this.treebankLanguagePack().basicCategory(cat);
        if (t.isPhrasal()) {
            List<String> childBasicCats = this.childBasicCats(t);
            if (this.markZuVP && baseCat.equals("VP") && (childBasicCats.contains("VZ") || childBasicCats.contains("VVIZU"))) {
                annotations.add("%ZU");
            }
            if (this.markRC && t.label() instanceof NegraLabel && baseCat.equals("S") && ((NegraLabel)t.label()).getEdge() != null && ((NegraLabel)t.label()).getEdge().equals("RC")) {
                annotations.add("%RC");
            }
            if (this.markContainsV && this.containsVP(t)) {
                annotations.add("%vp");
            }
            if (this.markLP && NegraPennTreebankParserParams.leftPhrasal(t)) {
                annotations.add("%LP");
            }
            if (this.markKonjParent) {
                for (String cCat : childBasicCats) {
                    if (!cCat.contains("-KONJ")) continue;
                    annotations.add("%konjp");
                    break;
                }
            }
            if (this.markHDParent) {
                for (String cCat : childBasicCats) {
                    if (!cCat.contains("-HD")) continue;
                    annotations.add("%hdp");
                    break;
                }
            }
        } else if (this.markColon && cat.equals("$.") && (word.equals(":") || word.equals(";"))) {
            annotations.add("-%colon");
        }
        StringBuilder catSB = new StringBuilder(cat);
        for (String annotation : annotations) {
            catSB.append(annotation);
        }
        t.setLabel(new CategoryWordTag(catSB.toString(), word, tag));
        return t;
    }

    private static boolean leftPhrasal(Tree t) {
        while (!t.isLeaf()) {
            String str = (t = t.lastChild()).label().value();
            if (!str.startsWith("NP") && !str.startsWith("PP") && !str.startsWith("VP") && !str.startsWith("S") && !str.startsWith("Q") && !str.startsWith("A")) continue;
            return true;
        }
        return false;
    }

    private boolean containsVP(Tree t) {
        Tree[] kids;
        String cat = this.tlp.basicCategory(t.label().value());
        if (cat.startsWith("V")) {
            return true;
        }
        for (Tree kid : kids = t.children()) {
            if (!this.containsVP(kid)) continue;
            return true;
        }
        return false;
    }

    private List<String> childBasicCats(Tree t) {
        Tree[] kids = t.children();
        ArrayList<String> l = new ArrayList<String>();
        for (Tree kid : kids) {
            l.add(this.basicCat(kid.label().value()));
        }
        return l;
    }

    @Override
    public List<? extends HasWord> defaultTestSentence() {
        String[] sent = new String[]{"Solch", "einen", "Zuspruch", "hat", "Angela", "Merkel", "lange", "nicht", "mehr", "erlebt", "."};
        return Sentence.toWordList(sent);
    }
}

