/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex.tsurgeon;

import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.tsurgeon.AuxiliaryTree;
import edu.stanford.nlp.trees.tregex.tsurgeon.CoindexationGenerator;
import edu.stanford.nlp.trees.tregex.tsurgeon.HoldTreeNode;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonMatcher;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonPattern;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonRuntimeException;
import edu.stanford.nlp.util.ArrayUtils;
import edu.stanford.nlp.util.CollectionUtils;
import edu.stanford.nlp.util.Function;
import java.util.List;
import java.util.Map;

class ReplaceNode
extends TsurgeonPattern {
    private static final Function<AuxiliaryTree, HoldTreeNode> convertAuxiliaryToHold = new Function<AuxiliaryTree, HoldTreeNode>(){

        @Override
        public HoldTreeNode apply(AuxiliaryTree t) {
            return new HoldTreeNode(t);
        }
    };

    public ReplaceNode(TsurgeonPattern oldNode, TsurgeonPattern ... newNodes) {
        super("replace", ArrayUtils.concatenate(new TsurgeonPattern[]{oldNode}, newNodes));
    }

    public ReplaceNode(TsurgeonPattern oldNode, List<AuxiliaryTree> trees) {
        this(oldNode, CollectionUtils.transformAsList(trees, convertAuxiliaryToHold).toArray(new TsurgeonPattern[trees.size()]));
    }

    @Override
    public TsurgeonMatcher matcher(Map<String, Tree> newNodeNames, CoindexationGenerator coindexer) {
        return new Matcher(newNodeNames, coindexer);
    }

    private class Matcher
    extends TsurgeonMatcher {
        public Matcher(Map<String, Tree> newNodeNames, CoindexationGenerator coindexer) {
            super(ReplaceNode.this, newNodeNames, coindexer);
        }

        @Override
        public Tree evaluate(Tree tree, TregexMatcher tregex) {
            Tree oldNode = this.childMatcher[0].evaluate(tree, tregex);
            if (oldNode == tree) {
                if (ReplaceNode.this.children.length > 2) {
                    throw new TsurgeonRuntimeException("Attempted to replace a root node with more than one node, unable to proceed");
                }
                return this.childMatcher[1].evaluate(tree, tregex);
            }
            Tree parent = oldNode.parent(tree);
            int i = parent.objectIndexOf(oldNode);
            parent.removeChild(i);
            for (int j = 1; j < ReplaceNode.this.children.length; ++j) {
                Tree newNode = this.childMatcher[j].evaluate(tree, tregex);
                parent.insertDtr(newNode.deepCopy(), i + j - 1);
            }
            return tree;
        }
    }
}

