/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.patterns.surface;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.patterns.surface.SurfacePattern;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class InvertedIndexByTokens
implements Serializable {
    private static final long serialVersionUID = 1L;
    Map<String, Hashtable<String, Set<String>>> index;
    boolean convertToLowercase;
    Set<String> stopWords;
    Set<String> specialWords;
    int numAllEntries = 0;
    boolean batchProcessSents = false;
    String filenamePrefix = null;

    public InvertedIndexByTokens(File invertedIndexDir, boolean lc, Set<String> stopWords, Set<String> specialWords, boolean batchProcessSents, String dirName) {
        this.index = new HashMap<String, Hashtable<String, Set<String>>>();
        this.convertToLowercase = lc;
        this.batchProcessSents = batchProcessSents;
        this.stopWords = stopWords;
        if (this.stopWords == null) {
            this.stopWords = new HashSet<String>();
        }
        this.specialWords = specialWords;
        this.filenamePrefix = dirName;
    }

    public InvertedIndexByTokens(Map<String, Hashtable<String, Set<String>>> index, boolean lc, Set<String> stopWords, Set<String> specialWords, boolean batchProcessSents, String dirName) {
        this.index = index;
        this.convertToLowercase = lc;
        this.batchProcessSents = batchProcessSents;
        this.stopWords = stopWords;
        if (this.stopWords == null) {
            this.stopWords = new HashSet<String>();
        }
        this.specialWords = specialWords;
        this.filenamePrefix = dirName;
    }

    void add(Map<String, List<CoreLabel>> sents, String filename, boolean indexLemma) {
        if (this.filenamePrefix != null) {
            filename = this.filenamePrefix + (this.filenamePrefix.endsWith("/") ? "" : "/") + filename;
        }
        for (Map.Entry<String, List<CoreLabel>> sEn : sents.entrySet()) {
            for (CoreLabel l : sEn.getValue()) {
                Set<String> sentids;
                Hashtable<String, Set<String>> t;
                String w = l.word();
                if (indexLemma) {
                    w = l.lemma();
                }
                if (this.convertToLowercase) {
                    w = w.toLowerCase();
                }
                if ((t = this.index.get(w)) == null) {
                    t = new Hashtable();
                }
                if ((sentids = t.get(filename)) == null) {
                    sentids = new HashSet<String>();
                }
                this.numAllEntries -= sentids.size();
                sentids.add(sEn.getKey());
                t.put(filename, sentids);
                this.numAllEntries += sentids.size();
                this.index.put(w, t);
            }
        }
    }

    public Map<String, Set<String>> getFileSentIds(String word) {
        return this.index.get(word);
    }

    public Map<String, Set<String>> getFileSentIds(Set<String> words) {
        Hashtable<String, Set<String>> sentids = new Hashtable<String, Set<String>>();
        for (String w : words) {
            Hashtable<String, Set<String>> st = this.index.get(w);
            if (st == null) {
                throw new RuntimeException("How come the index does not have sentences for " + w);
            }
            for (Map.Entry<String, Set<String>> en : st.entrySet()) {
                if (!sentids.containsKey(en.getKey())) {
                    sentids.put(en.getKey(), new HashSet());
                }
                sentids.get(en.getKey()).addAll((Collection<String>)en.getValue());
            }
        }
        return sentids;
    }

    public Map<String, Set<String>> getFileSentIdsFromPats(Set<SurfacePattern> pats) {
        HashSet<String> relevantWords = new HashSet<String>();
        for (SurfacePattern p : pats) {
            String[] prev;
            HashSet<String> relwordsThisPat = new HashSet<String>();
            String[] next = p.getSimplerTokensNext();
            if (next != null) {
                for (String s : next) {
                    s = s.trim();
                    if (this.convertToLowercase) {
                        s = s.toLowerCase();
                    }
                    if (s.isEmpty()) continue;
                    relwordsThisPat.add(s);
                }
            }
            if ((prev = p.getSimplerTokensPrev()) != null) {
                for (String s : prev) {
                    s = s.trim();
                    if (this.convertToLowercase) {
                        s = s.toLowerCase();
                    }
                    if (s.isEmpty()) continue;
                    relwordsThisPat.add(s);
                }
            }
            boolean nonStopW = false;
            for (String w : relwordsThisPat) {
                if (this.stopWords.contains(w) || this.specialWords.contains(w)) continue;
                relevantWords.add(w);
                nonStopW = true;
            }
            if (nonStopW) continue;
            relevantWords.addAll(relwordsThisPat);
        }
        relevantWords.removeAll(this.specialWords);
        return this.getFileSentIds(relevantWords);
    }

    public Set<String> getSpecialWordsList() {
        return this.specialWords;
    }

    public void saveIndex(String dir) throws IOException {
        BufferedWriter w = new BufferedWriter(new FileWriter(dir + "/param.txt"));
        w.write(String.valueOf(this.convertToLowercase) + "\n");
        w.write(String.valueOf(this.batchProcessSents) + "\n");
        w.write(this.filenamePrefix + "\n");
        w.close();
        IOUtils.writeObjectToFile(this.stopWords, dir + "/stopwords.ser");
        IOUtils.writeObjectToFile(this.specialWords, dir + "/specialwords.ser");
        IOUtils.writeObjectToFile(this.index, dir + "/map.ser");
    }

    public static InvertedIndexByTokens loadIndex(String dir) {
        try {
            List<String> lines = IOUtils.linesFromFile(dir + "/param.txt");
            boolean lc = Boolean.parseBoolean(lines.get(0));
            boolean batchProcessSents = Boolean.parseBoolean(lines.get(1));
            String filenameprefix = lines.get(2);
            if (filenameprefix.equals("null")) {
                filenameprefix = null;
            }
            Set stopwords = (Set)IOUtils.readObjectFromFile(dir + "/stopwords.ser");
            Set specialwords = (Set)IOUtils.readObjectFromFile(dir + "/specialwords.ser");
            Map index = null;
            index = (Map)IOUtils.readObjectFromFile(dir + "/map.ser");
            return new InvertedIndexByTokens(index, lc, (Set<String>)stopwords, (Set<String>)specialwords, batchProcessSents, filenameprefix);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot load the inverted index. " + e);
        }
    }

    public int size() {
        return this.index.size();
    }

    public boolean isBatchProcessed() {
        return this.batchProcessSents;
    }

    public int numAllEntries() {
        return this.numAllEntries;
    }

    public Set<String> getKeySet() {
        return this.index.keySet();
    }
}

