/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.utils;

import java.io.IOException;
import java.io.StringReader;

public class RFC2253Parser {
    public static String rfc2253toXMLdsig(String string) {
        String string2 = RFC2253Parser.normalize(string, true);
        return RFC2253Parser.rfctoXML(string2);
    }

    public static String xmldsigtoRFC2253(String string) {
        String string2 = RFC2253Parser.normalize(string, false);
        return RFC2253Parser.xmltoRFC(string2);
    }

    public static String normalize(String string) {
        return RFC2253Parser.normalize(string, true);
    }

    public static String normalize(String string, boolean bl) {
        if (string == null || string.isEmpty()) {
            return "";
        }
        try {
            int n;
            String string2 = RFC2253Parser.semicolonToComma(string);
            StringBuilder stringBuilder = new StringBuilder();
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            while ((n = string2.indexOf(44, n4)) >= 0) {
                if (n > 0 && string2.charAt(n - 1) != '\\' && (n3 += RFC2253Parser.countQuotes(string2, n4, n)) % 2 == 0) {
                    stringBuilder.append(RFC2253Parser.parseRDN(string2.substring(n2, n).trim(), bl)).append(',');
                    n2 = n + 1;
                    n3 = 0;
                }
                n4 = n + 1;
            }
            stringBuilder.append(RFC2253Parser.parseRDN(RFC2253Parser.trim(string2.substring(n2)), bl));
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            return string;
        }
    }

    static String parseRDN(String string, boolean bl) throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while ((n = string.indexOf(43, n4)) >= 0) {
            if (n > 0 && string.charAt(n - 1) != '\\' && (n3 += RFC2253Parser.countQuotes(string, n4, n)) % 2 == 0) {
                stringBuilder.append(RFC2253Parser.parseATAV(RFC2253Parser.trim(string.substring(n2, n)), bl)).append('+');
                n2 = n + 1;
                n3 = 0;
            }
            n4 = n + 1;
        }
        stringBuilder.append(RFC2253Parser.parseATAV(RFC2253Parser.trim(string.substring(n2)), bl));
        return stringBuilder.toString();
    }

    static String parseATAV(String string, boolean bl) throws IOException {
        int n = string.indexOf(61);
        if (n == -1 || n > 0 && string.charAt(n - 1) == '\\') {
            return string;
        }
        String string2 = RFC2253Parser.normalizeAT(string.substring(0, n));
        String string3 = null;
        string3 = string2.charAt(0) >= '0' && string2.charAt(0) <= '9' ? string.substring(n + 1) : RFC2253Parser.normalizeV(string.substring(n + 1), bl);
        return string2 + "=" + string3;
    }

    static String normalizeAT(String string) {
        String string2 = string.toUpperCase().trim();
        if (string2.startsWith("OID")) {
            string2 = string2.substring(3);
        }
        return string2;
    }

    static String normalizeV(String string, boolean bl) throws IOException {
        String string2 = RFC2253Parser.trim(string);
        if (string2.startsWith("\"")) {
            StringBuilder stringBuilder = new StringBuilder();
            StringReader stringReader = new StringReader(string2.substring(1, string2.length() - 1));
            int n = 0;
            while ((n = stringReader.read()) > -1) {
                char c = (char)n;
                if (c == ',' || c == '=' || c == '+' || c == '<' || c == '>' || c == '#' || c == ';') {
                    stringBuilder.append('\\');
                }
                stringBuilder.append(c);
            }
            string2 = RFC2253Parser.trim(stringBuilder.toString());
        }
        if (bl) {
            if (string2.length() > 0 && string2.charAt(0) == '#') {
                string2 = '\\' + string2;
            }
        } else if (string2.startsWith("\\#")) {
            string2 = string2.substring(1);
        }
        return string2;
    }

    static String rfctoXML(String string) {
        try {
            String string2 = RFC2253Parser.changeLess32toXML(string);
            return RFC2253Parser.changeWStoXML(string2);
        }
        catch (Exception exception) {
            return string;
        }
    }

    static String xmltoRFC(String string) {
        try {
            String string2 = RFC2253Parser.changeLess32toRFC(string);
            return RFC2253Parser.changeWStoRFC(string2);
        }
        catch (Exception exception) {
            return string;
        }
    }

    static String changeLess32toRFC(String string) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        StringReader stringReader = new StringReader(string);
        int n = 0;
        while ((n = stringReader.read()) > -1) {
            char c = (char)n;
            if (c == '\\') {
                stringBuilder.append(c);
                char c2 = (char)stringReader.read();
                char c3 = (char)stringReader.read();
                if ((c2 >= '0' && c2 <= '9' || c2 >= 'A' && c2 <= 'F' || c2 >= 'a' && c2 <= 'f') && (c3 >= '0' && c3 <= '9' || c3 >= 'A' && c3 <= 'F' || c3 >= 'a' && c3 <= 'f')) {
                    char c4 = (char)Byte.parseByte("" + c2 + c3, 16);
                    stringBuilder.append(c4);
                    continue;
                }
                stringBuilder.append(c2);
                stringBuilder.append(c3);
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    static String changeLess32toXML(String string) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        StringReader stringReader = new StringReader(string);
        int n = 0;
        while ((n = stringReader.read()) > -1) {
            if (n < 32) {
                stringBuilder.append('\\');
                stringBuilder.append(Integer.toHexString(n));
                continue;
            }
            stringBuilder.append((char)n);
        }
        return stringBuilder.toString();
    }

    static String changeWStoXML(String string) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        StringReader stringReader = new StringReader(string);
        int n = 0;
        while ((n = stringReader.read()) > -1) {
            char c = (char)n;
            if (c == '\\') {
                char c2 = (char)stringReader.read();
                if (c2 == ' ') {
                    stringBuilder.append('\\');
                    String string2 = "20";
                    stringBuilder.append(string2);
                    continue;
                }
                stringBuilder.append('\\');
                stringBuilder.append(c2);
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    static String changeWStoRFC(String string) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        int n3 = 0;
        while ((n = string.indexOf("\\20", n3)) >= 0) {
            stringBuilder.append(RFC2253Parser.trim(string.substring(n2, n))).append("\\ ");
            n2 = n + 3;
            n3 = n + 3;
        }
        stringBuilder.append(string.substring(n2));
        return stringBuilder.toString();
    }

    static String semicolonToComma(String string) {
        return RFC2253Parser.removeWSandReplace(string, ";", ",");
    }

    static String removeWhiteSpace(String string, String string2) {
        return RFC2253Parser.removeWSandReplace(string, string2, string2);
    }

    static String removeWSandReplace(String string, String string2, String string3) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while ((n = string.indexOf(string2, n4)) >= 0) {
            if (n > 0 && string.charAt(n - 1) != '\\' && (n3 += RFC2253Parser.countQuotes(string, n4, n)) % 2 == 0) {
                stringBuilder.append(RFC2253Parser.trim(string.substring(n2, n))).append(string3);
                n2 = n + 1;
                n3 = 0;
            }
            n4 = n + 1;
        }
        stringBuilder.append(RFC2253Parser.trim(string.substring(n2)));
        return stringBuilder.toString();
    }

    private static int countQuotes(String string, int n, int n2) {
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            if (string.charAt(i) != '\"') continue;
            ++n3;
        }
        return n3;
    }

    static String trim(String string) {
        String string2 = string.trim();
        int n = string.indexOf(string2) + string2.length();
        if (string.length() > n && string2.endsWith("\\") && !string2.endsWith("\\\\") && string.charAt(n) == ' ') {
            string2 = string2 + " ";
        }
        return string2;
    }
}

