/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.Repository;
import com.sun.org.apache.bcel.internal.classfile.JavaClass;
import com.sun.org.apache.bcel.internal.generic.ReferenceType;

public class ObjectType
extends ReferenceType {
    private final String class_name;

    public static ObjectType getInstance(String class_name) {
        return new ObjectType(class_name);
    }

    public ObjectType(String class_name) {
        super((byte)14, "L" + class_name.replace('.', '/') + ";");
        this.class_name = class_name.replace('/', '.');
    }

    public String getClassName() {
        return this.class_name;
    }

    @Override
    public int hashCode() {
        return this.class_name.hashCode();
    }

    @Override
    public boolean equals(Object type) {
        return type instanceof ObjectType ? ((ObjectType)type).class_name.equals(this.class_name) : false;
    }

    @Deprecated
    public boolean referencesClass() {
        try {
            JavaClass jc = Repository.lookupClass(this.class_name);
            return jc.isClass();
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Deprecated
    public boolean referencesInterface() {
        try {
            JavaClass jc = Repository.lookupClass(this.class_name);
            return !jc.isClass();
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public boolean referencesClassExact() throws ClassNotFoundException {
        JavaClass jc = Repository.lookupClass(this.class_name);
        return jc.isClass();
    }

    public boolean referencesInterfaceExact() throws ClassNotFoundException {
        JavaClass jc = Repository.lookupClass(this.class_name);
        return !jc.isClass();
    }

    public boolean subclassOf(ObjectType superclass) throws ClassNotFoundException {
        if (this.referencesInterfaceExact() || superclass.referencesInterfaceExact()) {
            return false;
        }
        return Repository.instanceOf(this.class_name, superclass.class_name);
    }

    public boolean accessibleTo(ObjectType accessor) throws ClassNotFoundException {
        JavaClass jc = Repository.lookupClass(this.class_name);
        if (jc.isPublic()) {
            return true;
        }
        JavaClass acc = Repository.lookupClass(accessor.class_name);
        return acc.getPackageName().equals(jc.getPackageName());
    }
}

