/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ModuleExports;
import com.sun.org.apache.bcel.internal.classfile.ModuleOpens;
import com.sun.org.apache.bcel.internal.classfile.ModuleProvides;
import com.sun.org.apache.bcel.internal.classfile.ModuleRequires;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class Module
extends Attribute {
    private final int module_name_index;
    private final int module_flags;
    private final int module_version_index;
    private ModuleRequires[] requires_table;
    private ModuleExports[] exports_table;
    private ModuleOpens[] opens_table;
    private final int uses_count;
    private final int[] uses_index;
    private ModuleProvides[] provides_table;

    Module(int name_index, int length, DataInput input, ConstantPool constant_pool) throws IOException {
        super((byte)22, name_index, length, constant_pool);
        int i;
        this.module_name_index = input.readUnsignedShort();
        this.module_flags = input.readUnsignedShort();
        this.module_version_index = input.readUnsignedShort();
        int requires_count = input.readUnsignedShort();
        this.requires_table = new ModuleRequires[requires_count];
        for (int i2 = 0; i2 < requires_count; ++i2) {
            this.requires_table[i2] = new ModuleRequires(input);
        }
        int exports_count = input.readUnsignedShort();
        this.exports_table = new ModuleExports[exports_count];
        for (int i3 = 0; i3 < exports_count; ++i3) {
            this.exports_table[i3] = new ModuleExports(input);
        }
        int opens_count = input.readUnsignedShort();
        this.opens_table = new ModuleOpens[opens_count];
        for (i = 0; i < opens_count; ++i) {
            this.opens_table[i] = new ModuleOpens(input);
        }
        this.uses_count = input.readUnsignedShort();
        this.uses_index = new int[this.uses_count];
        for (i = 0; i < this.uses_count; ++i) {
            this.uses_index[i] = input.readUnsignedShort();
        }
        int provides_count = input.readUnsignedShort();
        this.provides_table = new ModuleProvides[provides_count];
        for (int i4 = 0; i4 < provides_count; ++i4) {
            this.provides_table[i4] = new ModuleProvides(input);
        }
    }

    @Override
    public void accept(Visitor v) {
        v.visitModule(this);
    }

    public ModuleRequires[] getRequiresTable() {
        return this.requires_table;
    }

    public ModuleExports[] getExportsTable() {
        return this.exports_table;
    }

    public ModuleOpens[] getOpensTable() {
        return this.opens_table;
    }

    public ModuleProvides[] getProvidesTable() {
        return this.provides_table;
    }

    @Override
    public void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeShort(this.module_name_index);
        file.writeShort(this.module_flags);
        file.writeShort(this.module_version_index);
        file.writeShort(this.requires_table.length);
        for (ModuleRequires moduleRequires : this.requires_table) {
            moduleRequires.dump(file);
        }
        file.writeShort(this.exports_table.length);
        for (ModuleExports moduleExports : this.exports_table) {
            moduleExports.dump(file);
        }
        file.writeShort(this.opens_table.length);
        for (ModuleOpens moduleOpens : this.opens_table) {
            moduleOpens.dump(file);
        }
        file.writeShort(this.uses_index.length);
        for (int n : this.uses_index) {
            file.writeShort(n);
        }
        file.writeShort(this.provides_table.length);
        for (ModuleProvides moduleProvides : this.provides_table) {
            moduleProvides.dump(file);
        }
    }

    @Override
    public String toString() {
        ConstantPool cp = super.getConstantPool();
        StringBuilder buf = new StringBuilder();
        buf.append("Module:\n");
        buf.append("  name:    ").append(cp.getConstantString(this.module_name_index, (byte)19).replace('/', '.')).append("\n");
        buf.append("  flags:   ").append(String.format("%04x", this.module_flags)).append("\n");
        String version = this.module_version_index == 0 ? "0" : cp.getConstantString(this.module_version_index, (byte)1);
        buf.append("  version: ").append(version).append("\n");
        buf.append("  requires(").append(this.requires_table.length).append("):\n");
        for (ModuleRequires moduleRequires : this.requires_table) {
            buf.append("    ").append(moduleRequires.toString(cp)).append("\n");
        }
        buf.append("  exports(").append(this.exports_table.length).append("):\n");
        for (ModuleExports moduleExports : this.exports_table) {
            buf.append("    ").append(moduleExports.toString(cp)).append("\n");
        }
        buf.append("  opens(").append(this.opens_table.length).append("):\n");
        for (ModuleOpens moduleOpens : this.opens_table) {
            buf.append("    ").append(moduleOpens.toString(cp)).append("\n");
        }
        buf.append("  uses(").append(this.uses_index.length).append("):\n");
        for (int n : this.uses_index) {
            String class_name = cp.getConstantString(n, (byte)7);
            buf.append("    ").append(Utility.compactClassName(class_name, false)).append("\n");
        }
        buf.append("  provides(").append(this.provides_table.length).append("):\n");
        for (ModuleProvides moduleProvides : this.provides_table) {
            buf.append("    ").append(moduleProvides.toString(cp)).append("\n");
        }
        return buf.substring(0, buf.length() - 1);
    }

    @Override
    public Attribute copy(ConstantPool _constant_pool) {
        int i;
        Module c = (Module)this.clone();
        c.requires_table = new ModuleRequires[this.requires_table.length];
        for (i = 0; i < this.requires_table.length; ++i) {
            c.requires_table[i] = this.requires_table[i].copy();
        }
        c.exports_table = new ModuleExports[this.exports_table.length];
        for (i = 0; i < this.exports_table.length; ++i) {
            c.exports_table[i] = this.exports_table[i].copy();
        }
        c.opens_table = new ModuleOpens[this.opens_table.length];
        for (i = 0; i < this.opens_table.length; ++i) {
            c.opens_table[i] = this.opens_table[i].copy();
        }
        c.provides_table = new ModuleProvides[this.provides_table.length];
        for (i = 0; i < this.provides_table.length; ++i) {
            c.provides_table[i] = this.provides_table[i].copy();
        }
        c.setConstantPool(_constant_pool);
        return c;
    }
}

